Rem
Rem $Header: enq_basic.sql 19-jan-2007.13:33:10 chall    Exp $
Rem
Rem enq_basic.sql
Rem
Rem Copyright (c) 2007, Oracle.  All rights reserved.  
Rem
Rem    NAME
Rem      enq_basic.sql - Creates and enqueues a message.
Rem
Rem    DESCRIPTION
Rem      This script creates a message with payload type SYS.MGW_BASIC_MSG_T
Rem      and enqueues it to the queue MGWUSER.MGW_BASIC_SRC.
Rem
Rem    NOTES
Rem

declare
    enqueue_options    dbms_aq.enqueue_options_t;
    message_properties dbms_aq.message_properties_t;
    msgid              RAW(16);
    payload            sys.mgw_basic_msg_t;
    header             sys.mgw_name_value_array_t;
    text_body          sys.mgw_text_value_t;
BEGIN

  -- Create the header. This may normally be set to NULL.
  -- As an example, we set a couple of WebSphere MQ message properties
  -- via the built-in capabilities of MGW_BASIC_MSG_T. In most cases
  -- these properties will not need to be set.
  header := sys.mgw_name_value_array_t(
    sys.mgw_name_value_t.construct_integer('MGW_MQ_characterSet', '1208'),
    sys.mgw_name_value_t.construct_integer('MGW_MQ_priority', '7')
  );

  -- Create the text body.
  text_body := sys.mgw_text_value_t('sample text message', NULL);

  -- Construct the message from its constituent parts.
  payload := sys.mgw_basic_msg_t(header, text_body, NULL);

  -- Enqueue the message.
  dbms_aq.enqueue(queue_name         => 'mgwuser.mgw_basic_src',
                  enqueue_options    => enqueue_options,
                  message_properties => message_properties,
                  payload            => payload,
                  msgid              => msgid);
  commit;
END enqueue;
/
